/** @file
  This Driver does Board Info related Initialization.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2012 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#include <Base.h>
#include <Uefi.h>
#include <Library/BaseLib.h>
#include <Library/UefiBootServicesTableLib.h>
#include <Protocol/IrqBoardInfo.h>
#include "MultiPlatform/_RvpDt_BusNumberTranslator.h"
#include "MultiPlatform/_RvpDt_PirqTableData.h"
#include "MultiPlatform/_RvpDt_MpTableData.h"
#include <PlatformInfo.h>
#include "PlatformBoardId.h"
#include <Library/DebugLib.h>

GLOBAL_REMOVE_IF_UNREFERENCED UINT8              mBusNumberTranslatorTableData[] = BUS_NUMBER_TRANSLATOR_DATA;
GLOBAL_REMOVE_IF_UNREFERENCED PCI_IRQ_PIC_ROUTE  mPirqTableIrqData[]             = PIRQ_TABLE_IRQ_DATA;
GLOBAL_REMOVE_IF_UNREFERENCED PCI_IRQ_APIC_ROUTE mMpTableIrqData[]               = MP_TABLE_IRQ_DATA;
GLOBAL_REMOVE_IF_UNREFERENCED IRQ_APIC_INFO      mMpTableApicData[]              = MP_TABLE_APIC_DATA;

GLOBAL_REMOVE_IF_UNREFERENCED EFI_HANDLE  mIrqBoardInfoHandle = NULL;

/**
  Irq Board Info Protocol Handle.

  @param ImageHandle - ImageHandle
  @param SystemTable - Efi SystemTable Pointer

  @return EFI_STATUS
**/
EFI_STATUS
EFIAPI
IrqBoardEntryPoint(
  IN EFI_HANDLE ImageHandle,
  IN EFI_SYSTEM_TABLE *SystemTable
  )
{
  EFI_STATUS  Status;
  IRQ_BOARD_INFO_PROTOCOL *IrqBoardProtocol = NULL;
  PLATFORM_INFO           *PlatformInfo = NULL;

  //
  // Check for Non-ULT Desktop Platform(FlatheadCreek/BoardIdCrb/BoardIdHaddockCreek etc).
  //
  Status = gBS->LocateProtocol (&gPlatformInfoProtocolGuid, NULL, (VOID **) &PlatformInfo);
  ASSERT_EFI_ERROR (Status);

  if ((PlatformInfo->BoardType == BoardTypeRvp) &&
      (PlatformInfo->PlatformType == TypeTrad) &&
      ((PlatformInfo->PlatformFlavor == FlavorDesktop) ||
       (PlatformInfo->PlatformFlavor == FlavorWorkstation)||
       (PlatformInfo->PlatformFlavor  == FlavorUpServer))) {

    Status = gBS->LocateProtocol (&gIrqBoardInfoProtocolGuid, NULL, (VOID **) &IrqBoardProtocol);
    ASSERT_EFI_ERROR (Status);

    if (!(EFI_ERROR(Status))) {
      IrqBoardProtocol->PciDedicatedIrqs = PCI_DEDICATED_IRQS;
      IrqBoardProtocol->BusXlatTable = (PCI_BUS_XLAT_HDR*)&mBusNumberTranslatorTableData[0];
      IrqBoardProtocol->BusXlatLength = sizeof(mBusNumberTranslatorTableData);
      IrqBoardProtocol->PicRoutTable = (PCI_IRQ_PIC_ROUTE*)&mPirqTableIrqData[0];
      IrqBoardProtocol->PicRoutLength = sizeof(mPirqTableIrqData);
      IrqBoardProtocol->ApicRoutTable = (PCI_IRQ_APIC_ROUTE*)&mMpTableIrqData[0];
      IrqBoardProtocol->ApicRoutLength = sizeof(mMpTableIrqData);
      IrqBoardProtocol->ApicInfoTable = (IRQ_APIC_INFO*)&mMpTableApicData[0];
      IrqBoardProtocol->ApicInfoLength = sizeof(mMpTableApicData);
    }
  }
  return Status;
}
